ORCA/M Asm65816 2.1.0

0001 F9C7                       TITLE ', MISC.a - Get_TempBuff'
0002 F9C7              *
0003 F9C7              ****************************************************************
0004 F9C7              *
0005 F9C7              *              Get Temporary Buffer
0006 F9C7              *
0007 F9C7              *  Inputs:     A - Length of temporary buffer requested
0008 F9C7              *
0009 F9C7              *  Outputs:    TempBuff - Address of temporary buffer
0010 F9C7              *              A - status
0011 F9C7              *              C - set if error occurred
0012 F9C7              *
0013 F9C7              *  Zero Page used: none
0014 F9C7              *
0015 F9C7              ****************************************************************
0016 F9C7              *
0017 F9C7
0018 F9C7              Get_TempBuff PROC 
0019 F9C7                       with DirectPage
0020 F9C7              ;
0021 F9C7              ;        get a temporary buffer
0022 F9C7              ;
0023 F9C7 A2 00 00              ldx   #0                       ;output Handle
0024 F9CA DA                    phx   
0025 F9CB DA                    phx   
0026 F9CC DA                    phx   
0027 F9CD 48                    pha                            ;BlockSize
0028 F9CE F4 08 70              pea   uTempBuff                ;Owner
0029 F9D1 F4 00 80              pea   attrLocked               ;Attributes
0030 F9D4 DA                    phx                            ;Location
0031 F9D5 DA                    phx   
0032 F9D6
0033 F9D6 A2 02 09 22           _NewHandle 
0034 F9DD FA                    plx                            ;Handle
0035 F9DE 7A                    ply   
0036 F9DF B0 0C                 bcs   error
0037 F9E1              ;
0038 F9E1              ;        set TempBuff to address of temporary buffer
0039 F9E1              ;
0040 F9E1 8A                    txa   
0041 F9E2 20 D6 FA              jsr   DeRef
0042 F9E5 85 18                 sta   TempBuff
0043 F9E7 84 1A                 sty   TempBuff+2
0044 F9E9
0045 F9E9 A9 00 00     return   lda   #0
0046 F9EC 18                    clc   
0047 F9ED 60           error    rts   
0048 F9EE
0049 F9EE                       ENDP 
0050 F9EE
0051 F9EE                       TITLE ', MISC.a - Block_Move'
0052 F9EE              *
0053 F9EE              *************************************************************************
0054 F9EE              * BLOCK MOVE FOR NON-OVERLAPPING BLOCKS
0055 F9EE              *        (converted from ProDOS code)
0056 F9EE              *
0057 F9EE              * Moves a block of data from a source location to a destination
0058 F9EE              * location.  The source and destination blocks may overlap.
0059 F9EE              *
0060 F9EE              * Calling sequence:
0061 F9EE              *   Place machine in full native mode (e=0, m=0, x=0)
0062 F9EE              *   Push high order word of source pointer onto stack
0063 F9EE              *   Push low order word of source pointer
0064 F9EE              *   Push high order word of destination pointer
0065 F9EE              *   Push low order word of destination pointer
0066 F9EE              *   Push high order word of transfer count
0067 F9EE              *   Push low order word of transfer count
0068 F9EE              *   JSR Block_Move
0069 F9EE              * Outputs:  None
0070 F9EE              * Side effects:  Moves the block of data from source to destination
0071 F9EE              * Notes:
0072 F9EE              *   The high byte of Source, Dest, and Count must be zero
0073 F9EE              *   The Count may not be 0 or $FFFF.
0074 F9EE              *   This routine contains self modifying code--it cannot run in ROM
0075 F9EE              *************************************************************************
0076 F9EE              *
0077 F9EE
0078 F9EE              Block_Move PROC 
0079 F9EE
0080 F9EE              Source   equ   $0F                      ; 4-byte source address
0081 F9EE              Dest     equ   $0B                      ; 4-byte destination address
0082 F9EE              Count    equ   $07                      ; 4-byte transfer count
0083 F9EE              ReturnMove equ   $05                    ; 3-byte return address
0084 F9EE              TempCount equ   $03                     ; 2-byte temporary transfer count
0085 F9EE              *
0086 F9EE              MoveBlock equ   *                       ; main entry point
0087 F9EE 48                    pha                            ; push two bytes on stack for TempCount
0088 F9EF 0B                    phd                            ; save D
0089 F9F0 3B                    tsc                            ; make direct page correspond to stack
0090 F9F1 5B                    tcd   
0091 F9F2              *
0092 F9F2              * get ready to do the move
0093 F9F2              *
0094 F9F2 8B                    phb                            ; save DBR on stack (MVN trashes it)
0095 F9F3 4B                    phk                            ; set DBR to PBR
0096 F9F4 AB                    plb   
0097 F9F5 A6 0F                 ldx   Source                   ; X = low word of Source
0098 F9F7 A4 0B                 ldy   Dest                     ; Y = low word of Dest
0099 F9F9              *
0100 F9F9              * set up the self modifying code to contain dst src
0101 F9F9              *
0102 F9F9 A5 0D                 lda   Dest+2                   ; make sure high byte of Dest is 0
0103 F9FB 29 FF 00              and   #$00FF
0104 F9FE 85 0D                 sta   Dest+2
0105 FA00 A5 11                 lda   Source+2                 ; get source bank
0106 FA02 29 FF 00              and   #$00FF                   ; make sure high byte of Source is 0
0107 FA05 EB                    xba   
0108 FA06 05 0D                 ora   Dest+2                   ; or in destination bank (high byte must be zero)
0109 FA08 8D 52 FA              sta   DoMove+1                 ; put bank values into MVN instruction (danger)
0110 FA0B              *
0111 FA0B              * check for illegal values of Count
0112 FA0B              *
0113 FA0B A5 07                 lda   Count
0114 FA0D 05 09                 ora   Count+2
0115 FA0F F0 53                 beq   exit
0116 FA11 C9 FF FF              cmp   #$FFFF
0117 FA14 F0 4E                 beq   exit
0118 FA16              *
0119 FA16              * decrement Count because it contains actual transfer count whereas
0120 FA16              * remainder of routine assumes it contains transfer count - 1
0121 FA16              *
0122 FA16 A5 07                 lda   Count
0123 FA18 D0 02                 bne   @1
0124 FA1A C6 09                 dec   Count+2
0125 FA1C              @1        
0126 FA1C 3A                    dec   a
0127 FA1D 85 07                 sta   Count
0128 FA1F              *
0129 FA1F              * initialize TempCount
0130 FA1F              *
0131 FA1F 85 03                 sta   TempCount
0132 FA21 80 18                 bra   mdFirst
0133 FA23              *
0134 FA23              * main move loop
0135 FA23              *
0136 FA23 85 09        mdMore   sta   Count+2                  ; more bytes to move
0137 FA25 AF 52 FA 01           lda   >DoMove+1                ; A = SrcDst banks
0138 FA29 E0 01 00              cpx   #1                       ; bank cross? if X=0
0139 FA2C B0 03                 bcs   mdXNot0
0140 FA2E 69 00 01              adc   #$0100                   ; add 1 to source bank
0141 FA31 C0 00 00     mdXNot0  cpy   #0                       ; did destination cross bank?
0142 FA34 D0 01                 bne   mdYIs0
0143 FA36 1A                    inc   a
0144 FA37 8F 52 FA 01  mdYIs0   sta   >DoMove+1
0145 FA3B              mdFirst   
0146 FA3B 8A                    txa                            ; if count > -X then bank cross
0147 FA3C 49 FF FF              eor   #$FFFF
0148 FA3F C5 03                 cmp   TempCount
0149 FA41 B0 02                 bcs   mdXOk
0150 FA43 85 03                 sta   TempCount                ; only move -X bytes
0151 FA45 98           mdXOk    tya                            ; will destination cross bank?
0152 FA46 49 FF FF              eor   #$FFFF
0153 FA49 C5 03                 cmp   TempCount
0154 FA4B B0 02                 bcs   mdYOk
0155 FA4D 85 03                 sta   TempCount                ; only move -Y bytes
0156 FA4F A5 03        mdYOk    lda   TempCount                ; get the number of bytes to move
0157 FA51              *
0158 FA51              * the following 3 bytes are the actual move instruction
0159 FA51              * this routine dynamically modifies the source and destination banks
0160 FA51              *
0161 FA51 54           DoMove   DC B:$54                       ; opcode for MVN
0162 FA52 07                    DS B:1                         ; destination bank
0163 FA53 4C                    DS B:1                         ; source bank
0164 FA54              *
0165 FA54 A5 07                 lda   Count                    ; Count = Count - bytes moved
0166 FA56 18                    clc                            ; actual bytes moved 1 more than count
0167 FA57 E5 03                 sbc   TempCount
0168 FA59 85 07                 sta   Count
0169 FA5B 85 03                 sta   TempCount
0170 FA5D A5 09                 lda   Count+2
0171 FA5F E9 00 00              sbc   #0
0172 FA62 10 BF                 bpl   mdMore
0173 FA64              *
0174 FA64              * clean up everything before returning
0175 FA64              *
0176 FA64 AB           exit     plb                            ; restore DBR
0177 FA65 2B                    pld                            ; restore D
0178 FA66 68                    pla                            ; remove TempCount
0179 FA67              *
0180 FA67 A9 00 00              lda   #0
0181 FA6A 18                    clc   
0182 FA6B A8 68 83 0B           Stack_Cleanup 12
0183 FA79 60                    rts                            ; go home
0184 FA7A
0185 FA7A                       ENDP 
0186 FA7A
0187 FA7A                       TITLE ', MISC.a - MemMove'
0188 FA7A              ****************************************************************
0189 FA7A              *
0190 FA7A              *       pascal void MemMove(source, dest, n)
0191 FA7A              *       char    *source, *dest;
0192 FA7A              *       int     n;
0193 FA7A              *
0194 FA7A              * Description
0195 FA7A              *       Copies 'n' characters from memory area 'source' to 'dest'.
0196 FA7A              *       This function is the same as memcpy, except that can also
0197 FA7A              *       work on overlapping objects.
0198 FA7A              *
0199 FA7A              *       This was ripped off from the C library, and then modified
0200 FA7A              *       to be somewhat call-compatible with BlockMove.
0201 FA7A              *
0202 FA7A              ****************************************************************
0203 FA7A
0204 FA7A              MemMove  Func 
0205 FA7A
0206 FA7A              source   equ   $09
0207 FA7A              dest     equ   $05
0208 FA7A              n        equ   $03
0209 FA7A
0210 FA7A 3B                    tsc                            ;get current stack position
0211 FA7B 0B                    phd                            ;save current direct page
0212 FA7C 5B                    tcd                            ;set up local direct page
0213 FA7D
0214 FA7D A5 03                 lda   n                        ;check # of bytes to copy
0215 FA7F F0 35                 beq   exit                     ;if 0, don't bother!
0216 FA81 30 33                 bmi   exit                     ;if negative, skip it
0217 FA83
0218 FA83 A5 09                 lda   source                   ;get low word of source address
0219 FA85 38                    sec   
0220 FA86 E5 05                 sbc   dest                     ;calculate difference
0221 FA88 AA                    tax                            ;save in X for a bit
0222 FA89 A5 0B                 lda   source+2                 ;must do high word (to propogate carry)
0223 FA8B E5 07                 sbc   dest+2
0224 FA8D D0 14                 bne   normal                   ;if 'source' comes after 'dest', it doesn't matter
0225 FA8F E4 03                 cpx   n                        ;compare low word result against # of characters to move
0226 FA91 B0 10                 bcs   normal                   ;no overlap...
0227 FA93
0228 FA93              ; use this block if 'source' starts in the midst of 'dest'
0229 FA93
0230 FA93 A0 00 00              ldy   #0                       ;initialize index
0231 FA96 E2 20                 sep   #$20                     ;8-bit accumulator
0232 FA98                       longa off
0233 FA98
0234 FA98              @loop     
0235 FA98 B7 09                 lda   [source],y               ;get a character
0236 FA9A 97 05                 sta   [dest],y                 ;store in destination
0237 FA9C C8                    iny                            ;bump index
0238 FA9D C4 03                 cpy   n                        ;compare to # of characters to move
0239 FA9F 90 F7                 bcc   @loop                    ;continue until done
0240 FAA1 80 11                 bra   done                     ;then exit
0241 FAA3
0242 FAA3              ; use this block if there is no overlap or if 'dest' is higher in memory
0243 FAA3              ; than 'source'
0244 FAA3
0245 FAA3              normal    
0246 FAA3 A4 03                 ldy   n                        ;get # of characters to move
0247 FAA5 E2 20                 sep   #$20                     ;shift into 8-bit accumulator
0248 FAA7                       longa off
0249 FAA7 80 04                 bra   @do_it                   ;jump into loop
0250 FAA9
0251 FAA9              @loop     
0252 FAA9 B7 09                 lda   [source],y               ;get a byte
0253 FAAB 97 05                 sta   [dest],y                 ;and copy it
0254 FAAD              @do_it    
0255 FAAD 88                    dey                            ;one less byte to move
0256 FAAE D0 F9                 bne   @loop                    ;loop until at beginning of array
0257 FAB0 A7 09                 lda   [source]                 ;copy the last (first) byte
0258 FAB2 87 05                 sta   [dest]
0259 FAB4
0260 FAB4              done      
0261 FAB4 C2 20                 rep   #$20                     ;back to 16-bit accumulator
0262 FAB6                       longa on
0263 FAB6
0264 FAB6              exit      
0265 FAB6 2B                    pld   
0266 FAB7 A8 68 83 09           Stack_Cleanup 10
0267 FAC5 60                    rts   
0268 FAC6
0269 FAC6                       endf 
0270 FAC6
0271 FAC6                       TITLE ', MISC.a - DeRefUse'
0272 FAC6              *
0273 FAC6              ****************************************************************
0274 FAC6              *
0275 FAC6              *              Combines DeRef and UsePtr
0276 FAC6              *
0277 FAC6              *        Instead of:
0278 FAC6              *
0279 FAC6              *              jsr DeRef
0280 FAC6              *              jsr UsePtr
0281 FAC6              *
0282 FAC6              *        call:
0283 FAC6              *
0284 FAC6              *              jsr DeRefUse
0285 FAC6              *
0286 FAC6              ****************************************************************
0287 FAC6              *
0288 FAC6
0289 FAC6              DeRefUse PROC 
0290 FAC6
0291 FAC6 20 CF FA              jsr   UsePtr
0292 FAC9 BD 00 00              lda   |0,x
0293 FACC BC 02 00              ldy   |2,x
0294 FACF              ;        jsr   UsePtr
0295 FACF              ;        rts
0296 FACF              ;       fall into UsePtr
0297 FACF
0298 FACF                       TITLE ', MISC.a - UsePtr'
0299 FACF              *
0300 FACF              ****************************************************************
0301 FACF              *
0302 FACF              *        Use Pointer setup
0303 FACF              *
0304 FACF              *        Make a Pointer usable for indirect loading or storing
0305 FACF              *        without using Zero Page.  Here is an example of how
0306 FACF              *        this routine is used.  Suppose 'APtr' contains a Pointer
0307 FACF              *        to a Buffer and you want to extract the 1st 4 bytes
0308 FACF              *        out of the Buffer.  Remember the Pointer and the Buffer
0309 FACF              *        can be anywhere in memory.
0310 FACF              *
0311 FACF              *        lda   APtr                     ;lo bytes of Pointer
0312 FACF              *        ldy   APtr+2                   ;hi bytes of Pointer
0313 FACF              *        phb                            ;save DBR
0314 FACF              *        jsr   UsePtr                   ;call this routine
0315 FACF              *        lda   |0,x                     ;get 1st two bytes
0316 FACF              *        ldy   |2,x                     ;get 2nd two bytes
0317 FACF              *        plb                            ;restore DBR
0318 FACF              *
0319 FACF              *  Inputs:     A,Y - Pointer (Low bytes in A, High bytes in Y)
0320 FACF              *
0321 FACF              *  Outputs:    X   - Low bytes of Pointer
0322 FACF              *              DBR - Bank of Pointer
0323 FACF              *
0324 FACF              ****************************************************************
0325 FACF              *
0326 FACF                       Entry UsePtr
0327 FACF              UsePtr    
0328 FACF AA                    tax                            ;move lo bytes into X
0329 FAD0 98                    tya                            ;move hi bytes into A
0330 FAD1 EB                    xba                            ;get bank byte into B
0331 FAD2 48                    pha                            ;bank + trash
0332 FAD3 AB                    plb                            ;remove trash
0333 FAD4 AB                    plb                            ;set bank to bank of Pointer
0334 FAD5 60                    rts                            ;return
0335 FAD6
0336 FAD6                       ENDP 
0337 FAD6
0338 FAD6                       TITLE ', MISC.a - DeRef'
0339 FAD6              *
0340 FAD6              ****************************************************************
0341 FAD6              *
0342 FAD6              *        Dereference a Handle
0343 FAD6              *
0344 FAD6              *        Without using Zero Page
0345 FAD6              *
0346 FAD6              *  Inputs:     A,Y - Handle  (Low bytes in A, High bytes in Y)
0347 FAD6              *
0348 FAD6              *  Outputs:    A,Y - Pointer (Low bytes in A, High bytes in Y)
0349 FAD6              *              C   - set if Pointer=0
0350 FAD6              *
0351 FAD6              ****************************************************************
0352 FAD6              *
0353 FAD6              DeRef    PROC 
0354 FAD6
0355 FAD6 8B                    phb                            ;save DBR
0356 FAD7 DA                    phx                            ;save X
0357 FAD8 20 CF FA              jsr   UsePtr                   ;make Handle usable
0358 FADB 18                    clc   
0359 FADC BD 00 00              lda   |0,x
0360 FADF BC 02 00              ldy   |2,x
0361 FAE2 48                    pha                            ;save A
0362 FAE3 1D 02 00              ora   |2,x                     ;check whether pointer=0
0363 FAE6 D0 01                 bne   cont
0364 FAE8 38                    sec                            ;yes, set carry
0365 FAE9 68           cont     pla                            ;restore A
0366 FAEA FA                    plx                            ;restore X
0367 FAEB AB                    plb                            ;restore DBR
0368 FAEC 60                    rts                            ;return
0369 FAED
0370 FAED                       ENDP 
0371 FAED
0372 FAED                       TITLE ', MISC.a - save_dp'
0373 FAED              *
0374 FAED              ****************************************************************
0375 FAED              *
0376 FAED              *        saves contents of direct page
0377 FAED              *
0378 FAED              *  Inputs:      none
0379 FAED              *
0380 FAED              *  Outputs:     C   - set if problem allocating memory
0381 FAED              *               Handle to allocated memory is returned on stack
0382 FAED              *
0383 FAED              ****************************************************************
0384 FAED              *
0385 FAED              save_dp  Proc 
0386 FAED
0387 FAED A2 00 01              ldx   #256                     ;allocate 256 bytes
0388 FAF0 A0 00 00              ldy   #0
0389 FAF3 A9 01 7E              lda   #uTempDP                 ;UserID
0390 FAF6 20 52 D0              jsr   do_alloc                 ;allocate some memory
0391 FAF9 B0 24                 bcs   @nfg
0392 FAFB 68                    pla                            ;remove return address
0393 FAFC 5A                    phy                            ;save handle on stack
0394 FAFD DA                    phx   
0395 FAFE 48                    pha                            ;put return address back on stack
0396 FAFF 8A                    txa                            ;put low word into accumulator
0397 FB00 20 D6 FA              jsr   DeRef                    ;deref the handle
0398 FB03
0399 FB03 F4 00 00              pea   0                        ;make source pointer on stack
0400 FB06 0B                    phd   
0401 FB07
0402 FB07 5A                    phy                            ;put destination pointer on stack
0403 FB08 48                    pha   
0404 FB09 F4 00 00              pea   0                        ;put count on stack
0405 FB0C F4 00 01              pea   256
0406 FB0F 20 EE F9              jsr   Block_Move               ;copy the block
0407 FB12 A3 05                 lda   5,s                      ;duplicate handle on stack
0408 FB14 48                    pha   
0409 FB15 A3 05                 lda   5,s
0410 FB17 48                    pha   
0411 FB18 A2 02 22 22           _HUnlock                       ;let the block float around if necessary
0412 FB1F              @nfg      
0413 FB1F 60                    rts   
0414 FB20                       EndP 
0415 FB20
0416 FB20                       TITLE ', MISC.a - restore_dp'
0417 FB20              *
0418 FB20              ****************************************************************
0419 FB20              *
0420 FB20              *        restores previously saved direct page
0421 FB20              *
0422 FB20              *  Inputs:     Handle to saved direct page (on stack)
0423 FB20              *
0424 FB20              *  Outputs:    C   - set if Acc != 0 on entry
0425 FB20              *
0426 FB20              ****************************************************************
0427 FB20              *
0428 FB20              restore_dp Proc 
0429 FB20                       with Globals
0430 FB20
0431 FB20 8D A0 A6              sta   save_a                   ;save possible error code
0432 FB23 FA                    plx                            ;pull return address
0433 FB24 68                    pla                            ;retrieve DP buffer handle
0434 FB25 7A                    ply   
0435 FB26 DA                    phx                            ;put return address back on stack
0436 FB27 5A                    phy                            ;put handle on stack
0437 FB28 48                    pha                            ;for eventual _DisposeHandle call
0438 FB29 20 D6 FA              jsr   DeRef                    ;deref the handle
0439 FB2C 5A                    phy                            ;put on stack as source address
0440 FB2D 48                    pha   
0441 FB2E F4 00 00              pea   0                        ;put address of direct page on stack
0442 FB31 0B                    phd                            ;as destination address
0443 FB32 F4 00 00              pea   0                        ;count = 256
0444 FB35 F4 00 01              pea   256
0445 FB38 20 EE F9              jsr   Block_Move               ;go restore the direct page
0446 FB3B A2 02 10 22           _DisposeHandle                 ;release the DP buffer
0447 FB42 AD A0 A6              lda   save_a                   ;restore accumulator
0448 FB45 C9 01 00              cmp   #$0001                   ;condition carry
0449 FB48 60                    rts   
0450 FB49                       EndP 
